<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', current_locale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="app-name" content="<?php echo e(config('app.name')); ?>">

    <link rel="icon" type="image/png" sizes="56x56"
        href="<?php echo e(asset(get_option('primary_data')['favicon'] ?? 'favicon.png')); ?>">
    <title inertia name="app-name"><?php echo e(config('app.name', 'Laravel')); ?></title>

    <meta name="app-translations" content="<?php echo e(getTranslationFile()); ?>" />

    <script>
        "use strict"
        if (
            localStorage.getItem('theme') === 'dark' ||
            (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)
        ) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    </script>
    <script src="<?php echo e(asset('assets/js/initialLoader.js')); ?>" async></script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/custom.css')); ?>" media="all">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/custom-toastr.css')); ?>" media="all">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/payment.css')); ?>">

    <!-- Scripts -->
    <?php echo app('Tighten\Ziggy\BladeRouteGenerator')->generate(); ?>
    <?php
        $activeModule = isset($page['props']['activeModule']) ? $page['props']['activeModule'] : null;
    ?>
    <?php if($activeModule): ?>
        <?php if(Vite::isRunningHot()): ?>
            <?php echo app('Illuminate\Foundation\Vite')(["modules/{$activeModule}/resources/js/app.js", "modules/{$activeModule}/resources/js/Pages/{$page['component']}.vue"]); ?>
        <?php else: ?>
            <?php echo e(module_vite('build-' . str($activeModule)->kebab()->toString(), "modules/{$activeModule}/resources/js/app.js")); ?>

        <?php endif; ?>
    <?php else: ?>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js']); ?>
    <?php endif; ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/admin/main.scss']); ?>
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->head; } ?>
</head>

<body>
    <?php echo $__env->make('layouts.loader', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->body; } else { ?><div id="app" data-page="<?php echo e(json_encode($page)); ?>"></div><?php } ?>
</body>

</html>
<?php /**PATH /Users/trynos/Sites/whatsml/resources/views/layouts/admin.blade.php ENDPATH**/ ?>